#!/usr/bin/perl
# This is a simple script that converts a FastChip hex file to a
# C header file that contains the address and data information in
# C structures.
#
# usage: HexToStruct.pl <hexfile>

if ($#ARGV < 1) {
  print STDERR "usage: HexToStruct.pl HEXFILE STRUCT_NAME\n";
  exit 1;
}

$hexfile    = shift @ARGV;
$structname = shift @ARGV;

if (open (HANDLE, "$hexfile") == 0) {
  print STDERR "ERROR: cannot open $hexfile for reading\n";
  exit 1;
}

# Code to include in the header file before the data
$output = << 'EOF';
// AUTOMATICALLY GENERATED BY:
//   perl HexToStruct.pl $hexfile $structname
//
// This data structure is assumed:
//
//typedef struct {
//    data_32 address;
//    data_8  numBytes;
//    data_8  bytes[16];
//} DataRecord;

EOF

print $output;
print "DataRecord $structname\[\] =\n{\n\n";

# Now read the HexFile and 
$line = 0;
while (<HANDLE>) {
   ++$line;
   
   # Extended Linear Address Record
   if (/^:02000004([0-9a-f]{4})/i) {
       $currAddrHi = $1;
   } 

   # End of File
   elsif (/^:00000001ff/i) {
     last;
   }
   
   # Data Record
   elsif (/:([0-9a-f]{2})([0-9a-f]{4})00([0-9a-f]+)([0-9a-f]{2})/i) {
       $numBytes =   $1;
       $currAddrLo = $2;

       $bytes = $3;
       $bytes =~ s/([0-9a-f]{2})/0x\1,/ig;
       chop $bytes;

       print "    {0x$currAddrHi$currAddrLo,0x$numBytes,{$bytes}},\n";
   }
   
   else {
     print STDERR "ERROR: malformed record at line $line\n";
   }
}

close (HANDLE);

# close the brace of the last 
$output = << 'EOF';

    {0xffffffff, 0, {0}}
};
EOF

print $output;

exit 0;
