/*=========================================================================
| (c) 2000  Triscend Corporation
|--------------------------------------------------------------------------
| Project : Embedded E5 Jtag Library
|
| File    : JtagTap.c
|--------------------------------------------------------------------------
| Test driver program for the Embedded Jtag Library.
|
 ========================================================================*/

/*=========================================================================
| INCLUDES
 ========================================================================*/
#include "JtagTap.h"
#include "te5jtag.h"
#include "te5dl.h"
#include "te5disp.h"


/*=========================================================================
| CONSTANTS
 ========================================================================*/
#define PROGRAM_0  0
#define PROGRAM_1  1


/*=========================================================================
| FUNCTION
 ========================================================================*/
static void delay ()
{
    int i, j;
    for (i = 0; i < 1000; ++i)
        for (j = 0; j < 100; ++j)
            ;
}


/*=========================================================================
| FUNCTION
 ========================================================================*/
static void displayBytes (data_32 offset, data_8 numBytes)
{
    data_8  dataRead[1];
    data_8  i;

    for (i = 0; i < numBytes; ++i) {
        jtagReadMemory(offset+i, 1, dataRead, MEM_MODE_LONG);
        dispHex(dataRead[0]);
        delay();
    }
}
    

/*=========================================================================
| MAIN PROGRAM
 ========================================================================*/

// Reference:
//   Flash algorithms recognized by the flash programmer
//    * "AM29LV001",  128K
//    * "AM29LV002",  256K
//    * "AM29LV004",  512K
//    * "AM29LV008", 1024K
//    * "AM29LV116", 2048K
//    * "AT49x001",   128K
//    * "AT49x002",   256K
//    * "AT49x004",   512K
//    * "AT49x008",  1024K
//    * "DUAL_MODE", 4096K
//    
//   SEEPROM algorithms recognized by the SEEPROM programmer
//    * "AT17x65",      8K
//    * "AT17x128",    16K
//    * "AT17x256",    32K
//    * "AT17x512",    64K
//    * "AT17x010",   128K

void main ()
{
    volatile int loop = 0;
    
    JtagTap_INIT();
    
    dispHex(0xff);
    jtagInitialize();
    dlInitialize();

#if 0
    while (loop == 0)
    {
        dispHex(0xff);
    }
#endif
     
    // Load the data into the external SRAM of the target board
    // Memory parameters are specified as part of the data set.
    dlDownload(PROGRAM_0);
    
    // Check for any errors!
    if (gDlError != DL_OK) {
        data_8 error;
        if (gDlError == DL_JTAG_ERROR) error = jtagError;
        else                           error = gDlError;
        
        for (;;)
            dispHex(error);
    }
    
    for (;;) {
        // Remember that it is not possible to display the downloaded
        // bytes if this is SEEPROM.  Comment this out for now.
        // displayBytes(EXTERNAL_RAM_OFFSET, 8);

        // Instead, signal that the download is done
        dispHex(0xd0);
    }

    // Execution will never reach here.
    dlDeinitialize();
    jtagDeinitialize();
}
