/*=========================================================================
| (c) 2000  Triscend Corporation
|--------------------------------------------------------------------------
| Project : Embedded E5 Jtag Library
|
| File    : te5dl.h
|--------------------------------------------------------------------------
| Embedded downloader module
|
| Memory image format:
|
| Beginning of data         ---> 0000   ADDR1 [big endian]
|  (usually at 0x10000)          0004   ADDR2 [big endian]
|                                0008   ADDR3 [big endian]
|                                000c   0xffffffff
| ...
|                         ADDR1 +0000   Memory type
|                                       (1: Ext SRAM, 2: Flash, 3: SEEPROM)
|                         ADDR1 +0001   Memory capacity in KB [big endian]
|                         ADDR1 +0005   Device string [ASCIIZ, 31-bytes max]
|                         ADDR1 +0024   BLOCKADDR [big endian]
|                         ADDR1 +0028   LENGTH [1 byte]
|                         ADDR1 +0029   bytes to be downloaded
|                           ...
|                         [Repeat the previous three pieces]
|                           ...
|                         ADDR1 +XXXX   0xffffffff
| ...
|                         [Repeat for ADDR2 in the same way]
 ========================================================================*/
#ifndef __te5dl_h__
#define __te5dl_h__


/*=========================================================================
| INCLUDES
 ========================================================================*/
#include "te5types.h"

/*=========================================================================
| Constants
 ========================================================================*/
typedef enum {
    INTERNAL_SRAM  = 0,
    EXTERNAL_SRAM  = 1,
    FLASH_MEMORY   = 2,
    SEEPROM_MEMORY = 3
} MemoryType;


/*=========================================================================
| Constants for the E5 Chip
 ========================================================================*/
// Error codes for gDlError
#define DL_OK                      0x00
#define DL_JTAG_ERROR              0x01
#define DL_PROG_INDEX_OUT_OF_RANGE 0x02

// Errors reported from the programming algorithm
#define PROG_ERR_BAD_COMMAND       0x80
#define PROG_ERR_UNKNOWN_DEVICE    0x81
#define PROG_ERR_MEMORY_WRITE      0x82
#define PROG_ERR_MEMORY_ERASE      0x83
#define PROG_ERR_VERIFY            0x84

// Flash error code; matches codes above
extern data_8 gDlError;


/*=========================================================================
| Constants for the E5 Chip
 ========================================================================*/
#define INTERNAL_RAM_OFFSET  0x010000L
#define EXTERNAL_RAM_OFFSET  0x800000L


/*=========================================================================
| PROTOTYPES
 ========================================================================*/
void dlInitialize ();
void dlDeinitialize ();
void dlDownload (char index);



#endif
