/*=========================================================================
| (c) 2000  Triscend Corporation
|--------------------------------------------------------------------------
| Project : Embedded E5 Jtag Library
|
| File    : te5jtag.h
 ========================================================================*/
#ifndef __te5jtag_h__
#define __te5jtag_h__


/*=========================================================================
| INCLUDES
 ========================================================================*/
#include "te5types.h"
#include "te5tap.h"


/*=========================================================================
| ENUMS
 ========================================================================*/
typedef enum {
    JTAG_OK = 0,
    JTAG_ERR_CANT_STOP_TARGET,
    JTAG_ERR_TARGET_SECURITY_ERROR,
    JTAG_ERR_TARGET_COMM_FAILURE,
    JTAG_ERR_MEM_INVALID_MODE,
    JTAG_ERR_MEM_VERIFY_MISMATCH
} JtagError;

typedef enum {
    EXTEST          = 0,
    SAMPLE_PRELOAD  = 1,
    INTEST          = 2,
    IDCODE          = 3,
    MWRITE_LONG     = 4,
    BUSTAT          = 5,
    MREAD_LONG      = 6,
    DMADAT          = 7,
    SCAN            = 8,
    MWRITE          = 12,
    MREAD           = 14,
    MVERIFY         = 13,
    BYPASS          = 15
} E5_JTAG_OPCODE;

typedef enum {
    BUSCON_MCU_RESET      = 0x01,
    BUSCON_MCU_FREEZE     = 0x02,
    BUSCON_JINT_MCU       = 0x04,
    BUSCON_FORCE_BRST     = 0x08,
    BUSCON_FORCE_NOBRST   = 0x10,
    BUSCON_OSC_BREAK      = 0x20,
    BUSCON_J_XINT         = 0x40,
    BUSCON_STOP_CONTROL   = 0x6F
} E5_JTAG_BUSCON;

typedef enum {
    BUSTAT_MCU_FROZEN     = 0x01,
    BUSTAT_MCU_BREAKPOINT = 0x02,
    BUSTAT_MCU_RESET      = 0x04,
    BUSTAT_MCU_RUNNING    = 0x08,
    BUSTAT_FORCE_NOBRST   = 0x10,
    BUSTAT_OSC_BREAK      = 0x20,
    BUSTAT_J_XINT         = 0x40,
    BUSTAT_STOP_CONTROL   = 0x6F
} E5_JTAG_BUSTAT;


typedef enum
{
    MEM_MODE_DEFAULT,
    MEM_MODE_LONG,
    MEM_MODE_LONG_SHORT,
    MEM_MODE_SHORT,
    MEM_MODE_VERIFY,
    MEM_MODE_DMA,
    MEM_MODE_TRANSLATE
} JtagMemMode;


/*=========================================================================
| PROTOTYPES
 ========================================================================*/
/* This variable holds the last error number */
extern data_8 jtagError;

/* Methods by which to control the E5 through JTAG */
void     jtagInitialize ();
void     jtagDeinitialize ();

data_16  jtagBusStatus ();
void     jtagBusControl (data_16 buscon);

int      jtagAreYouThere ();
data_32  jtagDeviceID ();

void     jtagResetCpsu ();
void     jtagResetAndRun ();
void     jtagResetAndHalt ();
void     jtagRun ();
void     jtagStop ();

void jtagReadMemory (data_32          addr,
                     data_32          count,
                     data_8           bytes[],
                     JtagMemMode      mode);

void jtagWriteMemory (data_32       addr,
                      data_32       count,
                      data_8        bytes[],
                      JtagMemMode   mode);



#endif
