/*=========================================================================
| (c) 2000  Triscend Corporation
|--------------------------------------------------------------------------
| Project : Embedded E5 Jtag Library
|
| File    : te5tap.h
|--------------------------------------------------------------------------
 ========================================================================*/
#ifndef __te5tap_h__
#define __te5tap_h__


/*=========================================================================
| INCLUDES
 ========================================================================*/
#include "te5types.h"


/*=========================================================================
| ENUMS
 ========================================================================*/
typedef enum
{
    JTAG_REG_IR = 0,
    JTAG_REG_DR = 1
} JtagShiftReg;

typedef enum
{
    JTAG_STATE_TEST_LOGIC_RESET = 0xf,
    JTAG_STATE_RUN_TEST_IDLE    = 0xc,

    JTAG_STATE_SELECT_DR        = 0x7,
    JTAG_STATE_SELECT_IR        = 0x4,

    JTAG_STATE_CAPTURE_DR       = 0x6,
    JTAG_STATE_CAPTURE_IR       = 0xe,

    JTAG_STATE_SHIFT_DR         = 0x2,
    JTAG_STATE_SHIFT_IR         = 0xa,

    JTAG_STATE_EXIT1_DR         = 0x1,
    JTAG_STATE_EXIT1_IR         = 0x9,

    JTAG_STATE_PAUSE_DR         = 0x3,
    JTAG_STATE_PAUSE_IR         = 0xb,

    JTAG_STATE_EXIT2_DR         = 0x0,
    JTAG_STATE_EXIT2_IR         = 0x8,

    JTAG_STATE_UPDATE_DR        = 0x5,
    JTAG_STATE_UPDATE_IR        = 0xd
} JtagState;


/*=========================================================================
| PROTOTYPES
 ========================================================================*/
void tapInitialize ();

void tapDeinitialize ();

void tapJtagReset ();

void tapJtagScan (JtagShiftReg  reg,
                  data_8        bits,
                  JtagState     finalState,
                  data_8        dataIn[],
                  data_8        dataOut[]);


#endif
