/*=========================================================================
| (c) 2000  Triscend Corporation
|--------------------------------------------------------------------------
| Project : Embedded E5 Jtag Library
|
| File    : te5utils.c
 ========================================================================*/


/*=========================================================================
| INCLUDES
 ========================================================================*/
#include "te5utils.h"


/*=========================================================================
| FUNCTIONS
 ========================================================================*/
void
data16ToLittleEndian (data_8 dest[], const data_16 src, int pos)
{
    dest[pos++] = (src      ) & 0xff;
    dest[pos]   = (src >>  8) & 0xff;
}

void
data32ToLittleEndian (data_8 dest[], const data_32 src, int pos)
{
    dest[pos++] = (src      ) & 0xff;
    dest[pos++] = (src >>  8) & 0xff;
    dest[pos++] = (src >> 16) & 0xff;
    dest[pos]   = (src >> 24) & 0xff;
}

void
data16ToBigEndian (data_8 dest[], const data_16 src, int pos)
{
    dest[pos++] = (src >>  8) & 0xff;
    dest[pos]   = (src      ) & 0xff;
}

void
data32ToBigEndian (data_8 dest[], const data_32 src, int pos)
{
    dest[pos++] = (src >> 24) & 0xff;
    dest[pos++] = (src >> 16) & 0xff;
    dest[pos++] = (src >>  8) & 0xff;
    dest[pos]   = (src      ) & 0xff;
}

data_32
littleEndianToData32 (data_8 src[], int pos)
{
    data_32 dest;
    
    dest  = (src[pos++]);
    dest |= (src[pos++] <<  8);
    dest |= (src[pos++] << 16);
    dest |= (src[pos] << 24);
    
    return dest;
}

data_32
bigEndianToData32 (data_8 src[], int pos)
{
    data_32 dest;
    
    dest  = (src[pos++] << 24);
    dest |= (src[pos++] << 16);
    dest |= (src[pos++] <<  8);
    dest |= (src[pos]);
    
    return dest;
}
