/*=========================================================================
| (c) 2000  Triscend Corporation
|--------------------------------------------------------------------------
| Project : Embedded E5 Jtag Library
|
| File    : te5utils.h
 ========================================================================*/
#ifndef __te5utils_h__
#define __te5utils_h__


/*=========================================================================
| INCLUDES
 ========================================================================*/
#include "te5types.h"


/*=========================================================================
| PROTOTYPES
 ========================================================================*/
void    data16ToLittleEndian (data_8 dest[], const data_16 src, int pos);
void    data32ToLittleEndian (data_8 dest[], const data_32 src, int pos);
void    data16ToBigEndian (data_8 dest[], const data_16 src, int pos);
void    data32ToBigEndian (data_8 dest[], const data_32 src, int pos);
data_32 littleEndianToData32 (data_8 src[], int pos);
data_32 bigEndianToData32 (data_8 src[], int pos);


/*=========================================================================
| MACROS
 ========================================================================*/
#define data16ToJtag(dest, src) \
    data16ToLittleEndian(dest, src, 0)

#define data32ToJtag(dest, src) \
    data32ToLittleEndian(dest, src, 0)

#define jtagToData32(src) \
    littleEndianToData32(src, 0)

#define getBit(array, bitidx) \
    (array[(bitidx) >> 3] & (1<<((bitidx) & 0x7)))

#define setBit(array, bitidx, val) \
    ( (val) ? (array[(bitidx) >> 3] |=  (1<<((bitidx) & 0x7))) \
            : (array[(bitidx) >> 3] &= ~(1<<((bitidx) & 0x7))) )


#endif
