/*------------------------------------------------------------------------------

CountUpAgain.c

  (c) Copyright 1999 by Triscend Corporation (www.triscend.com).
  All Rights Reserved.

This simple program implements a counter on the 7 segment displays of the
evaluation board.  It includes secure software update libraries which allow
it to be updated by software download.

This code has additional functionality over CountUp.c.   Instead of incrementing
the count by 1 it reads a 4 bit value from the first (top) four switches of
DIP switch S1 and adds that value to the count.  This software also requires
additional CSL logic to interface with the DIP switch.

12/10/99

------------------------------------------------------------------------------*/


#include "CountUpAgain.h"    // FastChip Generated Include file with 8032 definitions
#include <rtx51tny.h>                 /* RTX-51 tiny functions & defines      */
#include <stdio.h>                    /* standard I/O .h-file                 */
#include <ctype.h>                    /* character functions                  */
#include <string.h>                   /* string and memory functions          */

#include "download.h"

// Diagnostic code - sets value on evaluation board dual 7 segment displays 
void status_code(unsigned char c) {
// Result is the seven segment display - it is defined in CountUpAgain.h
	Result=c;
} // status code

/******************************************************************************/
/*        Task 0 'init': Initialize is in user code not this library
          Initialize routine must call os_create_task(DOWNLOAD);              */
/******************************************************************************/

// Program Execution starts here - the main() function is owned by RTX51 Tiny.
init () _task_ INIT  { 
  //CountUpAgain_INIT();              // Initialisation function created by FastChip               
  os_create_task (DOWNLOAD);          /* start download code          */ 
  os_create_task (FIRST_USER_TASK);   // Start user code
  os_delete_task (INIT);     
}  // init



/******************************************************************************/
/*        User Task 'User':                                                      */
/******************************************************************************/


user_task () _task_ FIRST_USER_TASK {
unsigned char i; 

    i=0;
    while (1) {
		i=i+(SwitchS1 & 0x0F);
		status_code(i);
		// wait for a while without blocking other tasks
		os_wait(K_TMO,(unsigned char) 100,(unsigned int) 0);     
    }
} // download


