/*------------------------------------------------------------------------------

  decrypt.c

  (c) Copyright 1999 by Triscend Corporation (www.triscend.com).  All Rights Reserved.

  This code takes the encrypted data from transfer.c and converts it back into
  a functional Triscend CSoC image.

------------------------------------------------------------------------------*/



#include "download.h"
#include "datagram.h"
#include "install.h"
#include "des.h"

// Index of next write location in the Flash memory
unsigned long receive_flash_index;
// Size of image to be downloaded, as specified by PC.
unsigned long receive_flash_image_size;

static unsigned char cipher[8],plain[8];


//------------------ Application Level Protocol ---------------------------

static void decrypt_block(unsigned char new_cipher[8]);
static unsigned char check_mac(void);

static char receive_index;
static unsigned char receive_buffer[8];
static char state;

// states of the application level protocol
// Image format is:  IV (8 bytes), Image Length (4 bytes), Image Data (> 64K bytes)
#define WAITING_FOR_IV 0
#define WAITING_FOR_LENGTH 1
#define WAITING_FOR_DATA 2

void initialise_decrypt() {
  receive_index=0;
  receive_flash_index=0;
  receive_flash_image_size=0;
  state=WAITING_FOR_IV;
} // initialise_decrypt

unsigned long receive_long()
{
   char i;
   unsigned long l;
   
   l=0;
   for (i=0;i<4;i++) {
     l=(l<<8);
     l |= receive_buffer[i];
   }
   return l;
} // receive_long

// This routine is called for every valid character received from the PC after the
// datagram framing, etc. have been stripped out.
 void receive(c)
 unsigned char c;
 {
   char i;
   
   receive_buffer[receive_index]=c;
  	receive_index++;
	if (state==WAITING_FOR_IV) {
		if (receive_index==8) {
			for (i=0;i<8;i++) {
				// set up initial value for CBC decryption.
				cipher[i]=receive_buffer[i];
			}
			receive_index=0;
			state=WAITING_FOR_LENGTH;
		}

	} else if (state==WAITING_FOR_LENGTH) {
		if (receive_index==4) {
			receive_flash_image_size=receive_long();
			receive_index=0;
			state=WAITING_FOR_DATA;
		}

	} else {
	    // DES decrypts 64 bit (8 byte) blocks
		if (receive_index==8) {
			decrypt_block(receive_buffer);
			receive_index=0;
  			if ((receive_flash_image_size!=0)&&
  	 		    (receive_flash_index>=receive_flash_image_size+8)) {
					if (check_mac() && code_is_runnable()) {
  	 				    // Got a valid new configuration -- 
  	   	     			// Cryptographic MAC verifies correct download
  	   	                // and the software has a good head marker so CSoC can run it
  	   	                // -- end download process
  	 					close_channel(); 
					} else {
  	 				    deactivate();  // Delete the incorrect image from Flash.
 					    reset_channel();  // Inform PC that download failed, initialise for retry
 	 				}
			} 
  		}
	}
} // receive

//--------------------------  CRYPTOGRAPHY INTERFACE -----------------------------------

static void decrypt_block(new_cipher)
unsigned char new_cipher[8];
{
	unsigned char prev_cipher[8];
	char j;

  	// Do the actual decryption.
	
	for (j=0;j<8;j++) {
			prev_cipher[j]=cipher[j];
			cipher[j]=new_cipher[j];
		}
	// Chose single or triple DES decryption, symbol is defined in DES.h
#ifdef USE_TRIPLE_DES
	des3_ede_decrypt(cipher,plain);
#else
	des_single_decrypt(cipher,plain);
#endif
	for (j=0;j<8;j++) {
		plain[j]=plain[j] ^ prev_cipher[j];  // Cipher Block Chaining (CBC) mode
	}
	
	write_packet(plain);  // write decrypted data to flash memory
	receive_flash_index+=8;
} // decrypt_block


static unsigned char check_mac()
{
	unsigned char match,j;
	
   //status_code(0x55);
	//unsigned char pad;
   
   // Check Message Authentication Code (MAC).
	// MAC is the last block of the transmitted ciphertext and is the
	// second last ciphertext block encrypted again.  Therefore after
	// the CBC algorithm has decrypted the MAC and XOR'd it with the
	// previous ciphertext the result is 0.
	match=1;
	for (j=0;j<8;j++) {
	   	if (plain[j]!=0) {
			match=0;
			break;
		}
	}

	if (!match) {
		// Incorrect MAC
	    return 0;
	}
	// MAC is OK
	
	/*  Padding is not an issue - just leave it on.  A few extra bytes at the end of the
	    binary don't make a difference, they are already written to the Flash and cannot be
     	deleted without erasing the sector.
    pad=rec_flash[receive_flash_image_size-1];
	// Correct flash image size to remove padding bytes.
	// (See comments about padding in encrypt function).
	receive_flash_image_size=receive_flash_image_size-pad; */
	return 1;
} // check MAC


