/*------------------------------------------------------------------------------

download.c

(c) Copyright 1999 by Triscend Corporation (www.triscend.com).  All Rights Reserved.

This library manages the secure download of a new Triscend CSOC configuration
onto the Triscend E5 development board.  User programs must be linked with this library and
inclusion of this module (download) must be forced in the Keil C project editor
(because the call to the download task is made through RTX-51 the linker may
not detect that this module is required by the user project automatically).

3/10/99

------------------------------------------------------------------------------*/


#include <reg52.h>                    /* special function registers 8052      */
#include <rtx51tny.h>                 /* RTX-51 tiny functions & defines      */
#include <stdio.h>                    /* standard I/O .h-file                 */
#include <ctype.h>                    /* character functions                  */
#include <string.h>                   /* string and memory functions          */

#include "datagram.h"
#include "install.h"
#include "download.h"


/******************************************************************************
         Task 0 'init': Initialize is in user code - not this library
         User Initialize routine must call os_create_task(DOWNLOAD);              
******************************************************************************/



/******************************************************************************/
/*        Task 1 'Download':                                                      */
/******************************************************************************/


download () _task_ DOWNLOAD {
 
    
    initialise_flash();  // Clears half of the flash memory ready for download
    
    open_channel();      // Does not return until complete image is downloaded
    
    activate();          // Makes sure this image will be run after a reset
    
    os_delete_task(DOWNLOAD);  // all done here - code is loaded in Flash and waiting for a reset.
} // download


