;==========================================================================
; (c) 1999  Triscend Corporation
;--------------------------------------------------------------------------
; Project : Copy Code
; File    : jump2rom.a51
;--------------------------------------------------------------------------
; This module performs the low-level manipulations necessary to jump
; to the built-in ROM code that transfers control to the application code.
;==========================================================================

NAME ?JUMP?TO?ROM

;==========================================================================

; C prototype  -->  extern void jumpToRom();
PUBLIC JUMPTOROM

;==========================================================================

DPS        DATA  086H
CMAP1_CTL  EQU   0FF06h
CMAP2_CTL  EQU   0FF0CH

;==========================================================================

?JUMP?TO?ROM    SEGMENT CODE
                RSEG    ?JUMP?TO?ROM

JUMPTOROM:
        ; Reset the stack pointer to its power-up value
                MOV     SP, #07H

        ; Set the first data pointer to the address of CMAP1_CTL
                CLR     A
                MOV     DPS,A
                MOV     DPTR, #CMAP1_CTL

        ; Set the second data pointer to the address of CMAP2_CTL
                INC     DPS
                MOV     DPTR, #CMAP2_CTL

        ; Jump to the built-in ROM code
                LJMP    0FFF9H
END

;==========================================================================

;; Note: the built-in ROM code looks like this:
;;
;; 0FFF9H:      MOVX    @DPTR, A
;; 0FFFAH:      DEC     DPS
;; 0FFFCH:      MOV     A, #030H
;; 0FFFEH:      MOVX    @DPTR, A
;; 0FFFFH:      NOP
