/*------------------------------------------------------------------------------

  download.c

  (c) Copyright 1999 by Triscend Corporation (www.triscend.com).
  All Rights Reserved.

  This program reads an Intel hex format file representing a design for the
  Triscend CPSU, processes it to determine the FLASH memory contents, encapsulates
  this data, encrypts it using triple DES, appends a message authentication code
  and transfers the encrypted data to the Triscend evaluation board.

------------------------------------------------------------------------------*/



#include <stdlib.h>                /* prototype declarations for I/O functions */
#include <stdio.h>
#include "encrypt.h"
#include "readhex.h"
#include "datagram.h"



void main (int argc, char *argv[]) {
	// This .hex file is one generated by FastChip for an EPROM.  It must
	// contain the 'magic marker' or the CSoC will not boot correctly.  A
	// hex file from Keil only has the microcontroller code and needs to be
	// processed through Fast Chip.

	// argv[1] is the first command line parameter
	process_hex_file(argv[1]); 
	download_status=IN_PROGRESS;
	while (download_status==IN_PROGRESS) {
		setup_channel();
		encrypt();
		close_channel(); // flush out last datagram
		if ((download_status==IN_PROGRESS)||(download_status==DOWNLOAD_FAILS)) {
	        // IN_PROGRESS after end of transmission implies things are out of sync.
			printf("Download Failed - Software not Activated.\n");
			printf("Retrying.\n");
			download_status=IN_PROGRESS;
		}
	};
	// download_status==DOWNLOAD_SUCCEEDS
	printf("Download Succeeded\n Press Reset on the Evaluation Board to Activate\n");

} /* main */

