/*------------------------------------------------------------------------------

  encrypt.c

  (c) Copyright 1999 by Triscend Corporation (www.triscend.com).
  All Rights Reserved.

  This code provides the high level interface between the encryption library
  and the communications code.  It implements the Cipher Block Chaining mode
  of DES and provides high level data formatting:
  - padding the plaintext data to a multiple of 8 bytes for encryption
  - creating a random initial value (IV) for CBC mode
  - sending the IV and the size of the encrypted data to the receiver
  - calculating and appending the Message Authentication Code (MAC)


------------------------------------------------------------------------------*/



#include <stdlib.h>                /* prototype declarations for I/O functions */
#include <stdio.h>
#include <ctype.h>
#include <time.h>   // used to seed the random number generator

#include "encrypt.h"
#include "des.h"
#include "readhex.h"
#include "datagram.h"


void encrypt(void)
{
	unsigned char plain[8],cipher[8],iv[8];
	int i,j,pad;

	//slip_start_datagram();
 
	srand( (unsigned)time( NULL ) );  // seed the random number generator

	// Setup the Initial Value (IV) for CBC mode encryption.
    // Getting cryptographically strong random numbers is not critical for
	// initial values.
	for (j=0;j<8;j++) {
		// The maximum integer generated by rand(), RAND_MAX is compiler dependant
		// in the documentation but may be less than the full range of int
		// this code will work if RAND_MAX>=255.
		iv[j]=(rand() & 0xFF); 
		cipher[j]=iv[j];
		send_char(iv[j]);
	}
	// DES operates on 64 bit (8 byte) blocks of data.
	// Need to pad data out to be a multiple of 8 bytes.  Uses the
	// PKCS-7 standard technique to generate padding (see section 10.3
	// of the standard).  The PKCS standards are available on www.rsa.com.
	pad=8-(flash_image_size & 0x07);
	for (j=0;j<pad;j++) {
		flash[flash_image_size+j]=pad;
	}
	flash_image_size=flash_image_size+pad;
    printf("Transmitted flash image size %lx\n",flash_image_size);
    send_long(flash_image_size);

	// MAC is calculated by encrypting the final ciphertext block again.
	// To do this we zero the 8 bytes following the plaintext data in
	// the flash and run the encryption loop one cycle past the end of the
	// data to be encrypted.
	for (j=0;j<8;j++) {
		flash[flash_image_size+j]=0;
	}
	flash_image_size+=8;
	for (j=0;j<8;j++) {
		printf("iv=%x plain=%x ",iv[j],flash[j]);
	}
	printf("%lx\n",flash_image_size);
	// Do the actual encryption.
	// Cast to long to avoid warning about signed/unsigned comparison.
	// The MSB of flash_image_size is never going to be set since we
	// are dealing with 128K byte images.
	for (i=0;i< (long) flash_image_size;i+=8) {
		for (j=0;j<8;j++) {
			plain[j]=flash[i+j];
			plain[j]=plain[j] ^ cipher[j];  // Cipher Block Chaining (CBC) mode
		}
		//printf("Encrypt i=%x\n",i);
		des3_ede(plain,cipher);
		for (j=0;j<8;j++) {
			//flash[i+j]=cipher[j];
			send_char(cipher[j]);
		}
	}

    printf("Encryption Complete\n\n");
} // encrypt


